/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.SignedArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatMessageContent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.players.PlayerList;
import net.minecraftforge.common.ForgeHooks;
import org.slf4j.Logger;

public class MessageArgument
implements SignedArgument<Message> {
    private static final Collection<String> f_96829_ = Arrays.asList("Hello world!", "foo", "@e", "Hello @p :)");
    private static final Logger f_232145_ = LogUtils.getLogger();

    public static MessageArgument m_96832_() {
        return new MessageArgument();
    }

    public static Component m_96835_(CommandContext<CommandSourceStack> p_96836_, String p_96837_) throws CommandSyntaxException {
        Message messageargument$message = (Message)p_96836_.getArgument(p_96837_, Message.class);
        return messageargument$message.m_232196_((CommandSourceStack)p_96836_.getSource());
    }

    public static ChatMessage m_232163_(CommandContext<CommandSourceStack> p_232164_, String p_232165_) throws CommandSyntaxException {
        Message messageargument$message = (Message)p_232164_.getArgument(p_232165_, Message.class);
        Component component = messageargument$message.m_232196_((CommandSourceStack)p_232164_.getSource());
        CommandSigningContext commandsigningcontext = ((CommandSourceStack)p_232164_.getSource()).m_230898_();
        PlayerChatMessage playerchatmessage = commandsigningcontext.m_213987_(p_232165_);
        if (playerchatmessage == null) {
            ChatMessageContent chatmessagecontent = new ChatMessageContent(messageargument$message.f_96841_, component);
            return new ChatMessage(PlayerChatMessage.m_242673_((ChatMessageContent)chatmessagecontent));
        }
        return new ChatMessage(ChatDecorator.m_243125_((PlayerChatMessage)playerchatmessage, (Component)component));
    }

    public Message parse(StringReader p_96834_) throws CommandSyntaxException {
        return Message.m_96846_(p_96834_, true);
    }

    public Collection<String> getExamples() {
        return f_96829_;
    }

    public String m_213813_(Message p_242423_) {
        return p_242423_.m_169112_();
    }

    public CompletableFuture<Component> m_213969_(CommandSourceStack p_232147_, Message p_232148_) throws CommandSyntaxException {
        return p_232148_.m_232194_(p_232147_);
    }

    public Class<Message> m_213797_() {
        return Message.class;
    }

    static void m_232155_(CommandSourceStack p_232156_, CompletableFuture<?> p_232157_) {
        p_232157_.exceptionally(p_232154_ -> {
            f_232145_.error("Encountered unexpected exception while resolving chat message argument from '{}'", (Object)p_232156_.m_81357_().getString(), p_232154_);
            return null;
        });
    }

    public static class Message {
        final String f_96841_;
        private final Part[] f_96842_;

        public Message(String p_96844_, Part[] p_96845_) {
            this.f_96841_ = p_96844_;
            this.f_96842_ = p_96845_;
        }

        public String m_169112_() {
            return this.f_96841_;
        }

        public Part[] m_169113_() {
            return this.f_96842_;
        }

        CompletableFuture<Component> m_232194_(CommandSourceStack p_232195_) throws CommandSyntaxException {
            Component component = this.m_232196_(p_232195_);
            CompletableFuture completablefuture = p_232195_.m_81377_().m_236742_().m_236961_(p_232195_.m_230896_(), component);
            MessageArgument.m_232155_(p_232195_, completablefuture);
            return completablefuture;
        }

        Component m_232196_(CommandSourceStack p_232197_) throws CommandSyntaxException {
            return this.m_96849_(p_232197_, ForgeHooks.canUseEntitySelectors((SharedSuggestionProvider)p_232197_));
        }

        public Component m_96849_(CommandSourceStack p_96850_, boolean p_96851_) throws CommandSyntaxException {
            if (this.f_96842_.length != 0 && p_96851_) {
                MutableComponent mutablecomponent = Component.m_237113_((String)this.f_96841_.substring(0, this.f_96842_[0].m_96859_()));
                int i = this.f_96842_[0].m_96859_();
                for (Part messageargument$part : this.f_96842_) {
                    Component component = messageargument$part.m_96860_(p_96850_);
                    if (i < messageargument$part.m_96859_()) {
                        mutablecomponent.m_130946_(this.f_96841_.substring(i, messageargument$part.m_96859_()));
                    }
                    if (component != null) {
                        mutablecomponent.m_7220_(component);
                    }
                    i = messageargument$part.m_96862_();
                }
                if (i < this.f_96841_.length()) {
                    mutablecomponent.m_130946_(this.f_96841_.substring(i));
                }
                return mutablecomponent;
            }
            return Component.m_237113_((String)this.f_96841_);
        }

        public static Message m_96846_(StringReader p_96847_, boolean p_96848_) throws CommandSyntaxException {
            String s = p_96847_.getString().substring(p_96847_.getCursor(), p_96847_.getTotalLength());
            if (!p_96848_) {
                p_96847_.setCursor(p_96847_.getTotalLength());
                return new Message(s, new Part[0]);
            }
            ArrayList list = Lists.newArrayList();
            int i = p_96847_.getCursor();
            while (true) {
                EntitySelector entityselector;
                int j;
                block7: {
                    if (!p_96847_.canRead()) {
                        return new Message(s, list.toArray(new Part[0]));
                    }
                    if (p_96847_.peek() == '@') {
                        j = p_96847_.getCursor();
                        try {
                            EntitySelectorParser entityselectorparser = new EntitySelectorParser(p_96847_);
                            entityselector = entityselectorparser.m_121377_();
                            break block7;
                        }
                        catch (CommandSyntaxException commandsyntaxexception) {
                            if (commandsyntaxexception.getType() != EntitySelectorParser.f_121193_ && commandsyntaxexception.getType() != EntitySelectorParser.f_121191_) {
                                throw commandsyntaxexception;
                            }
                            p_96847_.setCursor(j + 1);
                            continue;
                        }
                    }
                    p_96847_.skip();
                    continue;
                }
                list.add(new Part(j - i, p_96847_.getCursor() - i, entityselector));
            }
        }
    }

    public record ChatMessage(PlayerChatMessage f_241639_) {
        public void m_241987_(CommandSourceStack p_242313_, Consumer<PlayerChatMessage> p_242409_) {
            MinecraftServer minecraftserver = p_242313_.m_81377_();
            p_242313_.m_241923_().m_241849_(() -> {
                CompletableFuture<FilteredText> completablefuture = this.m_241079_(p_242313_, this.f_241639_.m_241775_().f_241656_());
                CompletableFuture completablefuture1 = minecraftserver.m_236742_().m_243107_(p_242313_.m_230896_(), this.f_241639_);
                return CompletableFuture.allOf(completablefuture, completablefuture1).thenAcceptAsync(p_243162_ -> {
                    PlayerChatMessage playerchatmessage = ((PlayerChatMessage)completablefuture1.join()).m_243072_(((FilteredText)completablefuture.join()).f_243010_());
                    p_242409_.accept(playerchatmessage);
                }, (Executor)((Object)minecraftserver));
            });
        }

        private CompletableFuture<FilteredText> m_241079_(CommandSourceStack p_241399_, String p_241465_) {
            ServerPlayer serverplayer = p_241399_.m_230896_();
            return serverplayer != null && this.f_241639_.m_243088_(serverplayer.m_20148_()) ? serverplayer.m_8967_().m_6770_(p_241465_) : CompletableFuture.completedFuture(FilteredText.m_243054_((String)p_241465_));
        }

        public void m_241074_(CommandSourceStack p_241491_) {
            if (!this.f_241639_.m_241067_().m_241005_()) {
                this.m_241987_(p_241491_, p_243158_ -> {
                    PlayerList playerlist = p_241491_.m_81377_().m_6846_();
                    playerlist.m_241163_((PlayerChatMessage)p_243158_, Set.of());
                });
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ChatMessage.class, "signedArgument", "f_241639_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ChatMessage.class, "signedArgument", "f_241639_"}, this);
        }

        @Override
        public final boolean equals(Object p_232191_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ChatMessage.class, "signedArgument", "f_241639_"}, this, p_232191_);
        }
    }

    public static class Part {
        private final int f_96852_;
        private final int f_96853_;
        private final EntitySelector f_96854_;

        public Part(int p_96856_, int p_96857_, EntitySelector p_96858_) {
            this.f_96852_ = p_96856_;
            this.f_96853_ = p_96857_;
            this.f_96854_ = p_96858_;
        }

        public int m_96859_() {
            return this.f_96852_;
        }

        public int m_96862_() {
            return this.f_96853_;
        }

        public EntitySelector m_169114_() {
            return this.f_96854_;
        }

        @Nullable
        public Component m_96860_(CommandSourceStack p_96861_) throws CommandSyntaxException {
            return EntitySelector.m_175103_(this.f_96854_.m_121160_(p_96861_));
        }
    }
}

